/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001d\u0012\u0006\u0010$\u001a\u00020#\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\f\u00a2\u0006\u0004\b(\u0010)J)\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00040\u00030\u0003H&\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u0010\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00042\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u0004\u0018\u00018\u0000*\u00020\u00152\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001a8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001b\u0010\u001dR\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\f8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/statements/Statement;", "T", "", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "arguments", "()Ljava/lang/Iterable;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "execute", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "executeIn$exposed_core", "(Lorg/jetbrains/exposed/sql/Transaction;)Lkotlin/Pair;", "executeIn", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "sql", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "prepared", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "", "isAlwaysBatch", "Z", "()Z", "Lorg/jetbrains/exposed/sql/Table;", "targets", "Ljava/util/List;", "getTargets", "()Ljava/util/List;", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "getType", "()Lorg/jetbrains/exposed/sql/statements/StatementType;", "<init>", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "exposed-core"})
public abstract class Statement<T> {
    @NotNull
    private final StatementType type;
    @NotNull
    private final List<Table> targets;
    private final boolean isAlwaysBatch;

    public Statement(@NotNull StatementType type, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.type = type;
        this.targets = targets;
    }

    @NotNull
    public final StatementType getType() {
        return this.type;
    }

    @NotNull
    public final List<Table> getTargets() {
        return this.targets;
    }

    @Nullable
    public abstract T executeInternal(@NotNull PreparedStatementApi var1, @NotNull Transaction var2);

    @NotNull
    public abstract String prepareSQL(@NotNull Transaction var1);

    @NotNull
    public abstract Iterable<Iterable<Pair<IColumnType, Object>>> arguments();

    @NotNull
    public PreparedStatementApi prepared(@NotNull Transaction transaction2, @NotNull String sql2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        return transaction2.getConnection().prepareStatement(sql2, false);
    }

    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @Nullable
    public final T execute(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        return transaction2.exec(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<T, List<StatementContext>> executeIn$exposed_core(@NotNull Transaction transaction2) {
        T $i$f$forEachIndexed2;
        PreparedStatementApi $this$forEach$iv;
        List list2;
        StatementContext args;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Iterable<Iterable<Pair<IColumnType, Object>>> arguments2 = this.arguments();
        if (CollectionsKt.count(arguments2) > 0) {
            void $this$mapTo$iv$iv;
            Iterable<Iterable<Pair<IColumnType, Object>>> $this$map$iv = arguments2;
            boolean $i$f$map = false;
            Iterable<Iterable<Pair<IColumnType, Object>>> iterable = $this$map$iv;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementInterceptor it;
                Iterable iterable2 = (Iterable)item$iv$iv;
                Iterator iterator2 = destination$iv$iv;
                boolean bl = false;
                StatementContext context = new StatementContext(this, (Iterable<? extends Pair<? extends IColumnType, ? extends Object>>)((Object)args));
                Iterable $this$forEach$iv2 = Transaction.Companion.getGlobalInterceptors$exposed_core();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (GlobalStatementInterceptor)element$iv;
                    boolean bl2 = false;
                    it.beforeExecution(transaction2, context);
                }
                $this$forEach$iv2 = transaction2.getInterceptors$exposed_core();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (StatementInterceptor)element$iv;
                    boolean bl3 = false;
                    it.beforeExecution(transaction2, context);
                }
                iterator2.add((StatementContext)context);
            }
            list2 = (List)((Object)destination$iv$iv);
        } else {
            StatementInterceptor it;
            StatementContext context = new StatementContext(this, CollectionsKt.emptyList());
            Iterable $this$forEach$iv3 = Transaction.Companion.getGlobalInterceptors$exposed_core();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (GlobalStatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution(transaction2, context);
            }
            $this$forEach$iv3 = transaction2.getInterceptors$exposed_core();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (StatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution(transaction2, context);
            }
            list2 = CollectionsKt.listOf((Object)context);
        }
        List contexts = list2;
        try {
            $this$forEach$iv = this.prepared(transaction2, this.prepareSQL(transaction2));
        }
        catch (SQLException e) {
            throw new ExposedSQLException(e, contexts, transaction2);
        }
        PreparedStatementApi statement = $this$forEach$iv;
        Iterable $this$forEachIndexed$iv = contexts;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void context;
            int bl = index$iv;
            index$iv = bl + 1;
            if (bl < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            args = (StatementContext)item$iv;
            int i = bl;
            boolean bl4 = false;
            statement.fillParameters(context.getArgs());
            if (contexts.size() <= 1 && !this.isAlwaysBatch()) continue;
            statement.addBatch();
        }
        if (!transaction2.getDb().getSupportsMultipleResultSets()) {
            transaction2.closeExecutedStatements();
        }
        transaction2.setCurrentStatement(statement);
        try {
            $i$f$forEachIndexed2 = this.executeInternal(statement, transaction2);
        }
        catch (SQLException e) {
            throw new ExposedSQLException(e, contexts, transaction2);
        }
        T result2 = $i$f$forEachIndexed2;
        transaction2.setCurrentStatement(null);
        transaction2.getExecutedStatements$exposed_core().add(statement);
        Iterable $this$forEach$iv4 = Transaction.Companion.getGlobalInterceptors$exposed_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv4) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterExecution(transaction2, contexts, statement);
        }
        $this$forEach$iv4 = transaction2.getInterceptors$exposed_core();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv4) {
            StatementInterceptor it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterExecution(transaction2, contexts, statement);
        }
        return TuplesKt.to(result2, (Object)contexts);
    }
}

